/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;
import org.sonarlint.eclipse.core.AbstractPlugin;
import org.sonarlint.eclipse.core.internal.NewProjectListener;
import org.sonarlint.eclipse.core.internal.jobs.LogListener;
import org.sonarlint.eclipse.core.internal.jobs.StandaloneSonarLintClientFacade;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProject;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProjectManager;

public class SonarLintCorePlugin
extends AbstractPlugin {
    public static final String PLUGIN_ID = "org.sonarlint.eclipse.core";
    public static final String UI_PLUGIN_ID = "org.sonarlint.eclipse.ui";
    public static final String MARKER_ID = "org.sonarlint.eclipse.core.sonarlintProblem";
    private static SonarLintCorePlugin plugin;
    private static SonarLintProjectManager projectManager;
    private final List<LogListener> logListeners = new ArrayList<LogListener>();
    private StandaloneSonarLintClientFacade sonarlint;
    private final ServiceTracker proxyTracker;

    public SonarLintCorePlugin() {
        plugin = this;
        this.proxyTracker = new ServiceTracker(FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext(), IProxyService.class.getName(), null);
        this.proxyTracker.open();
    }

    public static SonarLintCorePlugin getDefault() {
        return plugin;
    }

    public void addLogListener(LogListener listener) {
        this.logListeners.add(listener);
    }

    public void removeLogListener(LogListener listener) {
        this.logListeners.remove(listener);
    }

    public void error(String msg) {
        for (LogListener listener : this.logListeners) {
            listener.error(msg);
        }
    }

    public void error(String msg, Throwable t) {
        for (LogListener listener : this.logListeners) {
            listener.error(msg);
            StringWriter stack = new StringWriter();
            t.printStackTrace(new PrintWriter(stack));
            listener.error(stack.toString());
        }
    }

    public void info(String msg) {
        for (LogListener listener : this.logListeners) {
            listener.info(msg);
        }
    }

    public void debug(String msg) {
        for (LogListener listener : this.logListeners) {
            listener.debug(msg);
        }
    }

    public void debug(String msg, Throwable t) {
        for (LogListener listener : this.logListeners) {
            listener.debug(msg);
            StringWriter stack = new StringWriter();
            t.printStackTrace(new PrintWriter(stack));
            listener.debug(stack.toString());
        }
    }

    public synchronized SonarLintProjectManager getProjectManager() {
        if (projectManager == null) {
            projectManager = new SonarLintProjectManager();
        }
        return projectManager;
    }

    @Override
    public void start(BundleContext context) {
        super.start(context);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new NewProjectListener(), 1);
        SonarLintCorePlugin.scheduleStartupJobs();
    }

    private static void scheduleStartupJobs() {
        Job job = new Job("Enable SonarLint on all projects"){

            protected IStatus run(IProgressMonitor monitor) {
                IWorkspaceRoot root;
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                if (workspace != null && (root = workspace.getRoot()) != null) {
                    SonarLintCorePlugin.enableAllProjects(monitor, root);
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.schedule();
    }

    private static void enableAllProjects(IProgressMonitor monitor, IWorkspaceRoot root) {
        IProject[] projects = root.getProjects(8);
        monitor.beginTask("Enable SonarLint builder...", projects.length);
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray[n2];
            if (iProject.isAccessible()) {
                monitor.subTask(iProject.getName());
                SonarLintProject slProject = SonarLintProject.getInstance((IResource)iProject);
                if (slProject != null && slProject.isAutoEnabled() && !slProject.isBuilderEnabled()) {
                    slProject.setBuilderEnabled(true);
                }
            }
            monitor.worked(1);
            ++n2;
        }
    }

    @Override
    public void stop(BundleContext context) {
        if (this.sonarlint != null) {
            this.sonarlint.stop();
        }
        this.proxyTracker.close();
        super.stop(context);
    }

    public StandaloneSonarLintClientFacade getDefaultSonarLintClientFacade() {
        if (this.sonarlint == null) {
            this.sonarlint = new StandaloneSonarLintClientFacade();
        }
        return this.sonarlint;
    }

    public IProxyService getProxyService() {
        return (IProxyService)this.proxyTracker.getService();
    }
}

